<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = strip_tags(trim($_POST["name"]));
    $email = filter_var(trim($_POST["email"]), FILTER_SANITIZE_EMAIL);
    $message = trim($_POST["message"]);

    if (empty($name) || empty($email) || empty($message) || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo "Invalid input!";
        exit;
    }

    $to = "contact@gaurly.com";  // Your Zoho Mail address
    $subject = "New Contact Form Submission from " . $name;
    $body = "You have received a new message from your website contact form.\n\n".
            "Name: $name\n".
            "Email: $email\n\n".
            "Message:\n$message\n";

    $headers = "From: $name <$email>\r\n";
    $headers .= "Reply-To: $email\r\n";

    // Use PHP's built-in mail function
    if (mail($to, $subject, $body, $headers)) {
        echo "success";
    } else {
        echo "error";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>Gaurily - Innovating the Future</title>
<link rel="shortcut icon" href="assets/images/favicon.ico">

<!-- Core Style Sheets -->
<link rel="stylesheet" href="assets/css/master.css">
<!-- Responsive Style Sheets -->
<link rel="stylesheet" href="assets/css/responsive.css">
<!-- Revolution Style Sheets -->
<link rel="stylesheet" type="text/css" href="revolution/css/settings.css">
<link rel="stylesheet" type="text/css" href="revolution/css/layers.css">
<link rel="stylesheet" type="text/css" href="revolution/css/navigation.css">
</head>
<body>

<!--== Loader Start ==-->
<div id="loader-overlay">
  <div class="loader">
    <div class="spinner-double-dot-in"></div>
  </div>
</div>
<!--== Loader End ==-->

<!--== Wrapper Start ==-->
<div class="wrapper">

  <!--== Header Start ==-->
  <nav class="navbar navbar-default navbar-fixed navbar-transparent dark bootsnav on no-full no-border studio brand-center">
  	<div class="container">
      <!--== Start Header Navigation ==-->
      <div class="navbar-header">
        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu"> <i class="tr-icon ion-android-menu"></i> </button>
        <div class="logo"> <a href="index.html"><img class="logo logo-display" src="assets/images/logo-black.png" alt=""> <img class="logo logo-scrolled" src="assets/images/logo-white.png" alt=""> </a> </div>
      </div>
      <!--== End Header Navigation ==-->

      <!--== Collect the nav links, forms, and other content for toggling ==-->
      <div class="collapse navbar-collapse" id="navbar-menu">
        <ul class="nav navbar-nav navbar-center" data-in="fadeIn" data-out="fadeOut">
          <li><a class="page-scroll" href="#home">Home</a></li>
          <li><a class="page-scroll" href="#feature">Features</a></li>
          <li><a class="page-scroll" href="#about">About</a></li>
          <li><a class="page-scroll" href="#team">Team</a></li>
          <li><a class="page-scroll" href="#work">Work</a></li>
          <li><a class="page-scroll" href="#pricing">Pricing</a></li>
          <li><a class="page-scroll" href="#blog">Blog</a></li>
          <li><a class="page-scroll" href="#contact">Contact</a></li>
        </ul>
      </div>
      <!--== /.navbar-collapse ==-->
    </div>

  </nav>
  <!--== Header End ==-->

  <!--== Hero Slider Start ==-->
  <div class="remove-padding transition-none" id="home">
    <div id="rev_slider_1174_1_wrapper" class="rev_slider_wrapper fullscreen-container" data-alias="inspiration-header" data-source="gallery" style="background-color:#f9f9f9;padding:0px;">
  <!-- START REVOLUTION SLIDER 5.4.1 fullscreen mode -->
  	<div id="rev_slider_1174_1" class="rev_slider fullscreenbanner" style="display:none;" data-version="5.4.1">
      <ul>	<!-- SLIDE  -->
      	<li data-index="rs-3238" data-transition="fade" data-slotamount="default" data-hideafterloop="0" data-hideslideonmobile="off"  data-easein="default" data-easeout="default" data-masterspeed="500"  data-rotate="0"  data-saveperformance="off"  data-title="Slide" data-param1="" data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10="" data-description="">
      		<!-- MAIN IMAGE -->
      		<img src="assets/images/transparent.png" data-bgcolor="#f9f9f9" alt=""  data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-bgparallax="off" class="rev-slidebg" data-no-retina />
      		<!-- LAYERS -->

      		<!-- LAYER NR. 1 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-8" id="slide-3238-layer-1"
      			data-x="['left','left','left','left']" data-hoffset="['-264','-264','-371','-416']"
      			data-y="['top','top','top','top']" data-voffset="['-135','-135','-180','-203']"
      			data-width="none"
      			data-height="none"
      			data-whitespace="nowrap"
      			data-type="image"
      			data-basealign="slide"
      			data-responsive_offset="on"
      			data-frames='[{"from":"x:left;rZ:-90deg;","speed":2500,"to":"o:1;","delay":500,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 5;border-width:0px;"><img src="assets/images/header_penpot.png" alt="" data-ww="['650px','650px','650px','650px']" data-hh="['500px','500px','500px','500px']" width="650" height="500" data-no-retina> </div>

      		<!-- LAYER NR. 2 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-9" id="slide-3238-layer-2"
      			data-x="['right','right','right','right']" data-hoffset="['30','30','-70','-144']"
      			data-y="['top','top','top','top']" data-voffset="['-204','-204','-233','-261']"
      			data-width="none"
      			data-height="none"
      			data-whitespace="nowrap"
      			data-type="image"
      			data-basealign="slide"
      			data-responsive_offset="on"
      			data-frames='[{"from":"x:right;y:-500px;rZ:90deg;","speed":2500,"to":"o:1;","delay":500,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 6;border-width:0px;"><img src="assets/images/header_flowerpot.png" alt="" data-ww="['700px','700px','700px','700px']" data-hh="['600px','600px','600px','600px']" width="700" height="600" data-no-retina /> </div>

      		<!-- LAYER NR. 3 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-10" id="slide-3238-layer-3"
      			data-x="['left','left','left','left']" data-hoffset="['-372','-372','-540','-638']"
      			data-y="['bottom','bottom','bottom','bottom']" data-voffset="['-484','-484','-520','-522']"
      			data-width="none"
      			data-height="none"
      			data-whitespace="nowrap"
      			data-type="image"
      			data-basealign="slide"
      			data-responsive_offset="on"
      			data-frames='[{"from":"x:left;rZ:45deg;","speed":2500,"to":"o:1;","delay":650,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 7;border-width:0px;"><img src="assets/images/header_papers.png" alt="" data-ww="['900px','900px','900px','900px']" data-hh="['1000px','1000px','1000px','1000px']" width="900" height="1000" data-no-retina /> </div>

      		<!-- LAYER NR. 4 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-12" id="slide-3238-layer-4"
      			data-x="['left','left','left','left']" data-hoffset="['134','134','-2','-57']"
      			data-y="['bottom','bottom','bottom','bottom']" data-voffset="['67','67','50','6']"
      			data-width="none"
      			data-height="none"
      			data-whitespace="nowrap"
      			data-type="image"
      			data-basealign="slide"
      			data-responsive_offset="on"
      			data-frames='[{"from":"y:bottom;rZ:90deg;","speed":1500,"to":"o:1;","delay":1050,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 8;border-width:0px;"><img src="assets/images/header_marker.png" alt="" data-ww="['200px','200px','200px','200px']" data-hh="['300px','300px','300px','300px']" width="200" height="300" data-no-retina /> </div>

      		<!-- LAYER NR. 5 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-11" id="slide-3238-layer-5"
      			data-x="['left','left','left','left']" data-hoffset="['181','181','30','-39']"
      			data-y="['bottom','bottom','bottom','bottom']" data-voffset="['-170','-170','-190','-212']"
      			data-width="none"
      			data-height="none"
      			data-whitespace="nowrap"
      			data-type="image"
      			data-basealign="slide"
      			data-responsive_offset="on"
      			data-frames='[{"from":"y:bottom;rZ:-90deg;","speed":1500,"to":"o:1;","delay":1250,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 9;border-width:0px;"><img src="assets/images/header_edding.png" alt="" data-ww="['300px','300px','300px','300px']" data-hh="['400px','400px','400px','400px']" width="300" height="400" data-no-retina /> </div>

      		<!-- LAYER NR. 6 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-12" id="slide-3238-layer-6"
      			data-x="['left','left','left','left']" data-hoffset="['393','393','201','81']"
      			data-y="['bottom','bottom','bottom','bottom']" data-voffset="['218','218','183','191']"
      			data-width="none"
      			data-height="none"
      			data-whitespace="nowrap"
      			data-type="image"
      			data-basealign="slide"
      			data-responsive_offset="on"
      			data-frames='[{"from":"y:bottom;rZ:-90deg;","speed":1500,"to":"o:1;","delay":500,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 10;border-width:0px;"><img src="assets/images/header_paperclip.png" alt="" data-ww="['50px','50px','50px','50px']" data-hh="['100px','100px','100px','100px']" width="50" height="100" data-no-retina /> </div>

      		<!-- LAYER NR. 7 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-11" id="slide-3238-layer-7"
      			data-x="['left','left','left','left']" data-hoffset="['346','346','165','36']"
      			data-y="['bottom','bottom','bottom','bottom']" data-voffset="['255','255','237','231']"
      			data-width="none"
      			data-height="none"
      			data-whitespace="nowrap"
      			data-type="image"
      			data-basealign="slide"
      			data-responsive_offset="on"
      			data-frames='[{"from":"y:bottom;rZ:90deg;","speed":2000,"to":"o:1;rZ:310;","delay":550,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 11;border-width:0px;"><img src="assets/images/header_paperclip.png" alt="" data-ww="['50px','50px','50px','50px']" data-hh="['100px','100px','100px','100px']" width="50" height="100" data-no-retina /> </div>

      		<!-- LAYER NR. 8 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-9" id="slide-3238-layer-8"
      			data-x="['right','right','right','right']" data-hoffset="['-364','-364','-479','-553']"
      			data-y="['bottom','bottom','bottom','bottom']" data-voffset="['-155','-155','-180','-202']"
      			data-width="none"
      			data-height="none"
      			data-whitespace="nowrap"
      			data-type="image"
      			data-basealign="slide"
      			data-responsive_offset="on"
      			data-frames='[{"from":"x:right;rZ:-65deg;","speed":1500,"to":"o:1;","delay":700,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 12;border-width:0px;"><img src="assets/images/header_tablet.png" alt="" data-ww="['730px','730px','730px','730px']" data-hh="['520px','520px','520px','520px']" width="730" height="520" data-no-retina /> </div>

      		<!-- LAYER NR. 9 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-11" id="slide-3238-layer-9"
      			data-x="['right','right','right','right']" data-hoffset="['222','222','105','8']"
      			data-y="['bottom','bottom','bottom','bottom']" data-voffset="['8','8','-17','-10']"
      			data-width="none"
      			data-height="none"
      			data-whitespace="nowrap"
      			data-type="image"
      			data-basealign="slide"
      			data-responsive_offset="on"
      			data-frames='[{"from":"x:right;rZ:90deg;","speed":1500,"to":"o:1;","delay":500,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 13;border-width:0px;"><img src="assets/images/header_pen.png" alt="" data-ww="['300px','300px','300px','300px']" data-hh="['500px','500px','500px','500px']" width="300" height="500" data-no-retina /> </div>

      		<!-- LAYER NR. 10 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-2" id="slide-3238-layer-10"
      			data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
      			data-y="['middle','middle','middle','middle']" data-voffset="['-70','-70','-70','-90']"
      			data-fontsize="['80','80','80','60']"
      			data-lineheight="['80','80','80','60']"
      			data-width="['none','none','none','360']"
      			data-height="none"
      			data-whitespace="['nowrap','nowrap','nowrap','normal']"
      			data-type="text"
      			data-responsive_offset="on"
      			data-frames='[{"from":"y:-50px;rX:-45deg;sX:2;sY:2;opacity:0;","speed":1500,"to":"o:1;","delay":510,"ease":"Power4.easeOut"},{"delay":640,"speed":600,"to":"y:30px;rX:45deg;sX:0.8;sY:0.8;opacity:0;","ease":"Power2.easeInOut"}]'
      			data-textAlign="['center','center','center','center']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 14; white-space: nowrap; font-size: 80px; line-height: 80px; font-weight: 800; color: rgba(0, 0, 0, 1.00);font-family: 'Raleway', sans-serif;border-width:0px;text-transform:uppercase;">Gaurily</div>

      		<!-- LAYER NR. 11 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-2" id="slide-3238-layer-11"
      			data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
      			data-y="['middle','middle','middle','middle']" data-voffset="['-70','-70','-70','-90']"
      			data-fontsize="['80','80','80','60']"
      			data-lineheight="['80','80','80','60']"
      			data-width="['none','none','none','360']"
      			data-height="none"
      			data-whitespace="['nowrap','nowrap','nowrap','normal']"
      			data-type="text"
      			data-responsive_offset="on"
      			data-frames='[{"from":"y:-50px;rX:-45deg;sX:2;sY:2;opacity:0;","speed":1500,"to":"o:1;","delay":2940,"ease":"Power4.easeOut"},{"delay":660,"speed":600,"to":"y:30px;rX:45deg;sX:0.8;sY:0.8;opacity:0;","ease":"Power2.easeInOut"}]'
      			data-textAlign="['center','center','center','center']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 15; white-space: nowrap; font-size: 80px; line-height: 80px; font-weight: 800; color: rgba(0, 0, 0, 1.00);font-family: 'Raleway', sans-serif;border-width:0px;text-transform:uppercase;">Innovating the Future</div>

      		<!-- LAYER NR. 12 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-2" id="slide-3238-layer-12"
      			data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
      			data-y="['middle','middle','middle','middle']" data-voffset="['-70','-70','-70','-90']"
      			data-fontsize="['80','80','80','60']"
      			data-lineheight="['80','80','80','60']"
      			data-width="['none','none','none','400']"
      			data-height="none"
      			data-whitespace="['nowrap','nowrap','nowrap','normal']"
      			data-type="text"
      			data-responsive_offset="on"
      			data-frames='[{"from":"y:-50px;rX:-45deg;sX:2;sY:2;opacity:0;","speed":1500,"to":"o:1;","delay":5390,"ease":"Power4.easeOut"},{"delay":"wait","speed":600,"to":"y:30px;rX:45deg;sX:0.8;sY:0.8;opacity:0;","ease":"Power2.easeInOut"}]'
      			data-textAlign="['center','center','center','center']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 16; white-space: nowrap; font-size: 80px; line-height: 80px; font-weight: 800; color: rgba(0, 0, 0, 1.00);font-family: 'Raleway', sans-serif;border-width:0px;text-transform:uppercase;">Explore Our Services</div>

      		<!-- LAYER NR. 13 -->
      		<div class="tp-caption tp-resizeme rs-parallaxlevel-2" id="slide-3238-layer-13"
      			data-x="['center','center','center','center']" data-hoffset="['-8','-8','-8','-8']"
      			data-y="['middle','middle','middle','middle']" data-voffset="['10','10','10','-10']"
      			data-fontsize="['20','20','20','25']"
      			data-lineheight="['20','20','20','30']"
      			data-width="['none','none','none','360']"
      			data-height="none"
      			data-whitespace="['nowrap','nowrap','nowrap','normal']"
      			data-type="text"
      			data-responsive_offset="on"
      			data-frames='[{"from":"y:50px;rX:45deg;sX:2;sY:2;opacity:0;","speed":1500,"to":"o:1;","delay":600,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['center','center','center','center']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 17; white-space: nowrap; font-size: 20px; line-height: 20px; font-weight: 500; color: rgba(0, 0, 0, 1.00);font-family: 'Raleway', sans-serif;border-width:0px;"></div>

      		<!-- LAYER NR. 14 -->
      		<div class="tp-caption rev-btn rs-parallaxlevel-3" id="slide-3238-layer-14"
      			data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
      			data-y="['middle','middle','middle','middle']" data-voffset="['92','92','92','92']"
      			data-width="none"
      			data-height="none"
      			data-whitespace="nowrap"
      			data-type="button"
      			data-actions='[{"event":"click","action":"scrollbelow","offset":"px","delay":""}]'
      			data-responsive_offset="on"
      			data-responsive="off"
      			data-frames='[{"from":"y:100px;rX:90deg;opacity:0;","speed":1500,"to":"o:1;","delay":700,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"},{"frame":"hover","speed":"150","ease":"Power1.easeInOut","to":"o:1;rX:0;rY:0;rZ:0;z:0;","style":"c:rgba(255, 255, 255, 1.00);bg:rgba(32, 85, 199, 1.00);bs:solid;"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[30,30,30,30]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[30,30,30,30]"
      			style="z-index: 18; white-space: nowrap; font-size: 15px; line-height: 50px; font-weight: 700; color: rgba(255, 255, 255, 1.00);font-family: 'Raleway', sans-serif;background-color:rgba(0, 0, 0, 1.00);border-color:rgba(0, 0, 0, 1.00);border-width:0px;border-radius:3px 3px 3px 3px;
            outline:none;box-shadow:none;box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;letter-spacing:2px;cursor:pointer;">CONTINUE </div>

      		<!-- LAYER NR. 15 -->
      		<div class="tp-caption rev-scroll-btn revs-light rs-parallaxlevel-5 dark" id="slide-3238-layer-15"
      			data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
      			data-y="['bottom','bottom','bottom','bottom']" data-voffset="['50','50','50','50']"
      			data-width="35"
      			data-height="55"
      			data-whitespace="nowrap"
      			data-type="button"
      			data-actions='[{"event":"click","action":"scrollbelow","offset":"px","delay":""}]'
      			data-basealign="slide"
      			data-responsive_offset="on"
      			data-responsive="off"
      			data-frames='[{"from":"y:-50px;opacity:0;","speed":1500,"to":"o:1;","delay":800,"ease":"Power4.easeOut"},{"delay":"wait","speed":300,"to":"opacity:0;","ease":"nothing"}]'
      			data-textAlign="['left','left','left','left']"
      			data-paddingtop="[0,0,0,0]"
      			data-paddingright="[0,0,0,0]"
      			data-paddingbottom="[0,0,0,0]"
      			data-paddingleft="[0,0,0,0]"
      			style="z-index: 19; min-width: 35px; max-width: 35px; max-width: 55px; max-width: 55px; white-space: nowrap; font-weight: 400;border-color:rgba(0, 0, 0, 1.00);border-style:solid;border-width:3px;border-radius:23px 23px 23px 23px;box-sizing:border-box;-moz-box-sizing:border-box;-webkit-box-sizing:border-box;cursor:pointer;">
            <span>
            </span>
          </div>
      	</li>
      </ul>
    <div class="tp-bannertimer tp-bottom" style="visibility: hidden !important;"></div></div>
    </div>
  </div>
  <!--== Hero Slider End ==-->

  <!--== Who We Are Start ==-->
    <!--== Who We Are Start ==-->
    <div class="white-bg pt-120 pb-120" id="feature">
    <div class="container">
      <div class="row">
        <div class="col-md-8 centerize-col text-center">
          <div class="section-title">
            <h4 class="default-color">Empowering Businesses with Technology</h4>
            <h1>Our Core Capabilities</h1>
            <p>
              At Gaurily, we specialize in delivering innovative digital solutions tailored to your business needs. From AI-driven automation to enterprise web applications, our expertise ensures efficiency, scalability, and success.
            </p>
          </div>
        </div>
      </div>
      <div class="row mt-50">
        <div class="col-md-3 col-sm-6 col-xs-12">
         <div class="feature-box text-center xs-mb-30 sm-mb-30 feature-box-default-bg light-border center-feature wow fadeInLeft" data-wow-delay="0.1s">
         	  <i class="icofont icofont-code-alt font-40px"></i>
          	<h4 class="mt-0 font-600">Custom Software Solutions</h4>
          	<p class="font-400">We develop tailored software and applications to meet your unique business requirements.</p>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
         <div class="feature-box text-center xs-mb-30 sm-mb-30 feature-box-default-bg light-border center-feature wow fadeInUp" data-wow-delay="0.2s">
         	 <i class="icofont icofont-electron font-40px"></i>
          	<h4 class="mt-0 font-600">AI & Machine Learning</h4>
          	<p class="font-400">Leverage AI to automate processes, enhance decision-making, and improve operational efficiency.</p>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
         <div class="feature-box text-center xs-mb-30 feature-box-default-bg light-border center-feature wow fadeInDown" data-wow-delay="0.3s">
         	 <i class="icofont icofont-rocket-alt-2 font-40px"></i>
          	<h4 class="mt-0 font-600">Scalable Web Applications</h4>
          	<p class="font-400">From responsive websites to SaaS platforms, our web applications scale with your business.</p>
          </div>
        </div>
        <div class="col-md-3 col-sm-6 col-xs-12">
         <div class="feature-box text-center feature-box-default-bg light-border center-feature wow fadeInRight" data-wow-delay="0.4s">
         	 <i class="icofont icofont-windows-lumia font-40px"></i>
          	<h4 class="mt-0 font-600">Power BI & Data Analytics</h4>
          	<p class="font-400">Transform data into actionable insights with our Power BI and advanced analytics solutions.</p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!--== Who We Are End ==-->
  <!--== About Company Start ==-->
  <div class="dark-bg pt-0 pb-0 about-section sm-pt-50 sm-pb-50" id="about">
    <div class="col-md-6 col-sm-6 bg-flex bg-flex-left">
      <div class="bg-flex-holder bg-flex-cover" style="background-image: url(assets/images/bg-left-img-2.jpg);"></div>
    </div>
    <div class="container-fluid">
      <div class="col-md-6 col-sm-6 col-md-offset-6 col-sm-offset-6">
          <div class="col-inner spacer text-left wow fadeInLeft" data-wow-delay="0.1s">
            <div class="mission-section xs-mb-80">
              <div class="section-title">
                <h4 class="default-color">Empowering Businesses with Technology</h4>
                <h1 class="white-color">Our Services</h1>
                <p>At Gaurily, we specialize in delivering cutting-edge digital solutions that drive business success. From AI-driven applications to enterprise software and IT consulting, we empower businesses to innovate, scale, and optimize their digital operations.</p>
              </div>
              <div class="panel-group accordion-style-01" id="accordion-style">
                <div class="panel">
                  <div class="panel-heading active-accordion"> <a data-toggle="collapse" data-parent="#accordion-style" href="#question1" aria-expanded="false" class="collapsed">
                    <div class="panel-title">Custom Software Solutions <span class="pull-right"><i class="ion-android-remove"></i></span> </div>
                    </a> </div>
                  <div id="question1" class="panel-collapse collapse in" aria-expanded="false" role="tablist">
                    <div class="panel-body"> We develop tailored software solutions, including enterprise applications, automation tools, and SaaS platforms, to enhance business efficiency and productivity. </div>
                  </div>
                </div>
                <div class="panel">
                  <div class="panel-heading"> <a data-toggle="collapse" data-parent="#accordion-style" href="#question2" aria-expanded="false" class="collapsed">
                    <div class="panel-title">AI & Machine Learning <span class="pull-right"><i class="ion-android-add"></i></span> </div>
                    </a> </div>
                  <div id="question2" class="panel-collapse collapse" aria-expanded="false" role="tablist">
                    <div class="panel-body"> We leverage AI to create intelligent automation, predictive analytics, and AI-driven solutions that streamline operations and enhance decision-making. </div>
                  </div>
                </div>
                <div class="panel">
                  <div class="panel-heading"> <a data-toggle="collapse" data-parent="#accordion-style" href="#question3" aria-expanded="false" class="collapsed">
                    <div class="panel-title">Cloud Solutions & Integration <span class="pull-right"><i class="ion-android-add"></i></span> </div>
                    </a> </div>
                  <div id="question3" class="panel-collapse collapse" aria-expanded="false" role="tablist">
                    <div class="panel-body"> We help businesses migrate to the cloud, optimize cloud infrastructure, and integrate API solutions for enhanced scalability and security. </div>
                  </div>
                </div>
                <div class="panel">
                  <div class="panel-heading"> <a data-toggle="collapse" data-parent="#accordion-style" href="#question4" aria-expanded="false" class="collapsed">
                    <div class="panel-title">IT Consulting & Staff Augmentation <span class="pull-right"><i class="ion-android-add"></i></span> </div>
                    </a> </div>
                  <div id="question4" class="panel-collapse collapse" aria-expanded="false" role="tablist">
                    <div class="panel-body"> Our team of expert developers and consultants integrate seamlessly into your business, offering specialized IT solutions and dedicated resources. </div>
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
  </div>
  <!--== About Company End ==-->


   <!--== Who We Are Start ==-->
   <div class="white-bg pt-0 pb-0 sm-pt-50 sm-pb-50 about-section">
    <div class="col-md-6 col-sm-6 bg-flex bg-flex-right">
      <div class="bg-flex-holder bg-flex-cover" style="background-image: url(assets/images/bg-left-img.jpg);"></div>
    </div>
    <div class="container-fluid">
      <div class="col-md-6 col-sm-6">
          <div class="col-inner spacer text-left wow fadeInRight" data-wow-delay="0.2s">
            <div class="mission-section xs-mb-80">
              <div class="section-title">
                <h4 class="default-color">Empowering Businesses with Technology</h4>
                <h1>About Gaurly</h1>
              </div>
              <p>
                At Gaurly, we specialize in delivering innovative software solutions tailored to businesses of all sizes. Our expertise spans AI-powered automation, software development, cloud integration, and IT consulting. With a strong focus on scalability and efficiency, we empower companies to stay ahead in the digital landscape.
              </p>
              <p>
                Our team of dedicated professionals is committed to delivering high-quality, robust, and customized solutions that drive business success. From AI-driven applications to enterprise-grade web solutions, we ensure technology works for you.
              </p>
              <p class="mt-30">
                <a class="btn btn-lg btn-color btn-default">Learn More</a>
              </p>
          </div>
          </div>
        </div>
      </div>
  </div>
  <!--== Who We Are End ==-->

  <!--== Call to Actions Start ==-->
  <section class="parallax-bg fixed-bg sm-pb-80 sm-pt-80" data-parallax-bg-image="assets/images/background/parallax-bg.jpg" data-parallax-speed="0.5" data-parallax-direction="up">
    <div class="overlay-bg"></div>
    <div class="container">
      <div class="row row-flex flex-center">
          <div class="col-md-3 col-sm-6 col-xs-12 xs-mb-30 sm-mb-30">
            <div class="counter-wrap wow fadeInLeft" data-wow-delay="0.1s">
              <i class="icofont icofont-award font-40px default-color"></i>
              <h2><span class="counter font-600 open-font white-color">100</span></h2>
              <h3 class="font-400 text-uppercase white-color">Satisfied Clients</h3>
            </div>
          </div>
          <div class="col-md-3 col-sm-6 col-xs-12 xs-mb-30 sm-mb-30">
            <div class="counter-wrap wow fadeInUp" data-wow-delay="0.2s">
              <i class="icofont icofont-coffee-mug font-40px default-color"></i>
              <h2><span class="counter font-600 open-font white-color">20</span></h2>
              <h3 class="font-400 text-uppercase white-color">Ongoing Projects</h3>
            </div>
          </div>
          <div class="col-md-3 col-sm-6 col-xs-12 xs-mb-30">
            <div class="counter-wrap wow fadeInDown" data-wow-delay="0.3s">
              <i class="icofont icofont-briefcase font-40px default-color"></i>
              <h2><span class="counter font-600 open-font white-color">100</span></h2>
              <h3 class="font-400 text-uppercase">Project Delivered</h3>
            </div>
          </div>
          <div class="col-md-3 col-sm-6 col-xs-12">
            <div class="counter-wrap wow fadeInRight" data-wow-delay="0.4s">
              <i class="icofont icofont-chart-radar-graph font-40px default-color"></i>
              <h2><span class="counter font-600 open-font white-color">25</span></h2>
              <h3 class="font-400 text-uppercase white-color">Expert Team Members</h3>
            </div>
          </div>
        </div>
    </div>
  </section>
  <!--== Call to Actions End ==-->

  <!--== Pricing Table Start ==-->
  <div class="white-bg pt-120 pb-120" id="pricing">
    <div class="container">
      <div class="row">
        <div class="col-md-8 centerize-col text-center">
          <div class="section-title">
            <h4 class="default-color">Pricing Plan</h4>
            <h1>Our Packages</h1>
            <p>
              Choose the perfect plan for your business needs. Gaurly offers scalable and tailored solutions for startups, SMEs, and enterprises.
            </p>
          </div>
        </div>
      </div>
        <div class="row mt-50">
          <div class="col-md-4 pricing-table col-sm-4 xs-mb-30">
            <div class="pricing-box pricing-box-bg text-left wow fadeInLeft" data-wow-delay="0.1s">
              <div class="plan-name">
                <h3>Startup</h3>
              </div>
              <div class="value">
                <h3>99<span>$</span></h3>
                <span class="per">Per Month</span>
              </div>
              <ul>
              	<li>Responsive Website Development</li>
                <li>Basic SEO Optimization</li>
                <li>5 Pages Included</li>
                <li>Standard Support</li>
                <li>Basic Analytics</li>
                <li>Email Integration</li>
              </ul>
              <div class="pricing-box-bottom"> <a class="btn btn-dark btn-md btn-default">Get Started</a> </div>
            </div>
          </div>

          <div class="col-md-4 pricing-table col-sm-4 xs-mb-30">
            <div class="pricing-box featured pricing-box-bg text-left">
              <div class="plan-name">
                <h3>Business</h3>
              </div>
              <div class="value">
                <h3>199<span>$</span></h3>
                <span class="per">Per Month</span>
              </div>
              <ul>
              	<li>Advanced Web Development</li>
                <li>SEO & Performance Optimization</li>
                <li>Up to 15 Pages</li>
                <li>Priority Support</li>
                <li>Advanced Analytics</li>
                <li>CRM & E-Commerce Integration</li>
              </ul>
              <div class="pricing-box-bottom"> <a class="btn btn-dark btn-md btn-default">Get Started</a> </div>
            </div>
          </div>

          <div class="col-md-4 pricing-table col-sm-4">
            <div class="pricing-box pricing-box-bg text-left wow fadeInRight" data-wow-delay="0.2s">
              <div class="plan-name">
                <h3>Enterprise</h3>
              </div>
              <div class="value">
                <h3>499<span>$</span></h3>
                <span class="per">Per Month</span>
              </div>
              <ul>
              	<li>Custom Web Application Development</li>
                <li>AI & ML Integrations</li>
                <li>Unlimited Pages</li>
                <li>Dedicated Support</li>
                <li>Advanced Security & Compliance</li>
                <li>Cloud Hosting & API Integrations</li>
              </ul>
              <div class="pricing-box-bottom"> <a class="btn btn-dark btn-md btn-default">Get Started</a> </div>
            </div>
          </div>
        </div>
    </div>
  </div>
  <!--== Pricing Table End ==-->


  <!--== Testimonials Start ==-->
  <!-- <section class="parallax-bg fixed-bg sm-pb-80 sm-pt-80" data-parallax-bg-image="assets/images/background/parallax-bg-3.jpg" data-parallax-speed="0.2" data-parallax-direction="up" id="testimonial">
    <div class="dark-overlay-bg"></div>
    <div class="container">
      <div class="row">
          <div class="testimonial-style-6">
          	<div class="col-xs-12">
      				<div class="testimonial-item text-center">
      				  <div class="testimonial-content white-color">
                  <img class="img-responsive" src="assets/images/team/avatar-1.jpg" alt="avatar-1">
      				  	<h3 class="mt-20 line-height-40 font-200">“Very much satisfied with the service. Delivered on time and responded to request for modifications within few hours.</h3>
                  <h5 class="font-600 mb-0 white-color text-uppercase letter-spacing-2">- David Levine -</h5>
      				  </div>
      				</div>
          	</div>

          	<div class="col-xs-12">
      				<div class="testimonial-item text-center">
                <div class="testimonial-content white-color">
                  <img class="img-responsive" src="assets/images/team/avatar-2.jpg" alt="avatar-2">
      				  	<h3 class="mt-20 line-height-40 font-200">“I’m very happy with the results! They went above and beyond for me and that is always appreciated! I would highly recommend SH to anybody!”</h3>
                  <h5 class="font-600 mb-0 white-color text-uppercase letter-spacing-2">- Kevin SCHER -</h5>
      				  </div>
      				</div>
  			    </div>
      			<div class="col-xs-12">
      				<div class="testimonial-item text-center">
                <div class="testimonial-content white-color">
                  <img class="img-responsive" src="assets/images/team/avatar-3.jpg" alt="avatar-3">
      				  	<h3 class="mt-20 line-height-40 font-200">“Great work I got a lot more than what I ordered, they are very legítimas and catchy. I went for one of them for my brand but is always better to have more options.”</h3>
                  <h5 class="font-600 mb-0 white-color text-uppercase letter-spacing-2">- Sam Wander -</h5>
      				  </div>
      				</div>
      			</div>
  		    </div>
        </div>
    </div>
  </section> -->
  <!--== Testimonials End ==-->

  <!--== Map Start ==-->
  <!-- <div class="container-fluid">
    <div class="row">
      <div class="wide" id="map-style-3"></div>
    </div>
  </div> -->
  <!--== Map End ==-->

  <!--== Contact Start ==-->
    <!--== Contact Start ==-->
    <div class="white-bg pt-120 pb-120" id="contact">
    <div class="container">
      <div class="row">
        <div class="col-md-6 col-sm-6 col-xs-12">
          <div class="section-title text-left">
            <h4 class="default-color mt-0">Let's Connect</h4>
            <h1>Contact Us</h1>
          </div>
          <div class="mt-50">
            <div class="icon-text feature-box-2 mb-30 clearfix">
              <div class="icon">
                <i class="icofont icofont-google-map font-30px white-color"></i>
              </div>
              <h3 class="mt-0">Our Office</h3>
              <div class="dis">
                IT Park, Dehradun, India
              </div>
            </div>
            <div class="icon-text feature-box-2 mb-30 clearfix">
              <div class="icon">
                <i class="icofont icofont-iphone font-30px white-color"></i>
              </div>
              <h3 class="mt-0">Call Us</h3>
              <div class="dis">
                +91 98765 43210
              </div>
            </div>
            <div class="icon-text feature-box-2 mb-30 clearfix">
              <div class="icon">
                <i class="icofont icofont-mail font-30px white-color"></i>
              </div>
              <h3 class="mt-0">Email Us</h3>
              <div class="dis">
                <a href="mailto:contact@gaurly.com">contact@gaurly.com</a>
              </div>
            </div>
          </div>
        </div>

        <div class="col-md-6 col-sm-6 col-xs-12">
          <form name="contact-form" id="contact-form" action="send-mail.php" method="POST" class="contact-form-style-01">
            <div class="messages"></div>
            <div class="row mt-50">
              <div class="col-md-6 col-sm-6">
                <div class="form-group">
                  <label class="sr-only" for="name">Name</label>
                  <input type="text" name="name" class="md-input" id="name" placeholder="Your Name *" required data-error="Your Name is Required">
                  <div class="help-block with-errors"></div>
                </div>
              </div>
              <div class="col-md-6 col-sm-6">
                <div class="form-group">
                  <label class="sr-only" for="email">Email</label>
                  <input type="email" name="email" class="md-input" id="email" placeholder="Your Email *" required data-error="Please Enter Valid Email">
                  <div class="help-block with-errors"></div>
                </div>
              </div>
              <div class="col-md-12 col-sm-12">
                <div class="form-group">
                  <label class="sr-only" for="message">Message *</label>
                  <textarea name="message" class="md-textarea" id="message" rows="5" required data-error="Please, Leave us a message" placeholder="Your Message *"></textarea>
                  <div class="help-block with-errors"></div>
                </div>
              </div>
              <div class="col-md-12 col-sm-12">
                <div class="text-left">
                  <button type="submit" name="submit" class="btn btn-color btn-md btn-default btn-animate remove-margin"><span>Send <i class="ion-android-arrow-forward"></i></span></button>
                </div>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
  <!--== Contact End ==-->

  <!--== Contact End ==-->

  <!--== Footer Start ==-->
  <footer class="footer">
    <div class="footer-copyright">
      <div class="container">
        <div class="row wow fadeInUp" data-wow-delay="0.1s">
          <div class="col-md-8 centerize-col text-center">
            <div class="footer-logo">
              <a href="index.html"><img src="assets/images/logo-white.png" class="img-responsive centerize-col" alt="Footer Logo"/></a>
            </div>
            <div class="copy-right">Copyright 2019, All rights reserved.</div>
            <ul class="social-media mt-30 float-none">
              <li><a href="#" class="icofont icofont-facebook"></a></li>
      			  <li><a href="#" class="icofont icofont-twitter"></a></li>
      			  <li><a href="#" class="icofont icofont-behance"></a></li>
      			  <li><a href="#" class="icofont icofont-dribble"></a></li>
              <li><a href="#" class="icofont icofont-linkedin"></a></li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </footer>
  <!--== Footer End ==-->

  <!--== Go to Top  ==-->
  <a href="javascript:" id="return-to-top"><i class="icofont icofont-arrow-up"></i></a>
  <!--== Go to Top End ==-->

</div>
<!--== Wrapper End ==-->

<!--== Javascript Plugins ==-->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDZyHJoaWdCd2PI5o6p6G2IjPUPDodlUlM"></script>
<script src="assets/js/jquery.min.js"></script>
<script src="assets/js/smoothscroll.js"></script>
<script src="assets/js/plugins.js"></script>
<script src="assets/js/master.js"></script>

<!-- Revolution js Files -->
<script src="revolution/js/jquery.themepunch.tools.min.js"></script>
<script src="revolution/js/jquery.themepunch.revolution.min.js"></script>
<script src="revolution/js/revolution.extension.actions.min.js"></script>
<script src="revolution/js/revolution.extension.carousel.min.js"></script>
<script src="revolution/js/revolution.extension.kenburn.min.js"></script>
<script src="revolution/js/revolution.extension.layeranimation.min.js"></script>
<script src="revolution/js/revolution.extension.migration.min.js"></script>
<script src="revolution/js/revolution.extension.navigation.min.js"></script>
<script src="revolution/js/revolution.extension.parallax.min.js"></script>
<script src="revolution/js/revolution.extension.slideanims.min.js"></script>
<script src="revolution/js/revolution.extension.video.min.js"></script>
<!--== Javascript Plugins End ==-->

</body>
</html>
